// hud-master-password-addon.js
// เพิ่ม "ถามรหัส/ตั้งรหัสใหม่" ตอนกดปุ่ม "เลือก" ในหน้าจอ Master Chooser
(() => {
  const API = "https://hud-api-v2.kingking090ai.workers.dev";

  async function postJSON(path, body) {
    const res = await fetch(API + path, {
      method: "POST",
      headers: { "content-type": "application/json" },
      body: JSON.stringify(body || {}),
      credentials: "omit",
      cache: "no-store",
      mode: "cors"
    });
    let data = null;
    try { data = await res.json(); } catch {}
    if (!res.ok) {
      const err = (data && (data.error || data.message)) || `${res.status}`;
      throw new Error(err);
    }
    return data;
  }

  function getRowName(row) {
    // <div class="item"><div>NAME</div><div><button class="warning">เลือก</button>...</div></div>
    if (!row) return "";
    const first = row.querySelector(":scope > div");
    if (first) return (first.textContent || "").trim();
    // fallback
    return (row.textContent || "").trim().split(/\s+/)[0] || "";
  }

  function ensureResetButtons() {
    const list = document.querySelector("#hud-masters-list");
    if (!list) return;
    list.querySelectorAll(".item").forEach((row) => {
      if (row.querySelector(".reset-pass")) return;
      const holder = row.querySelector(":scope > div:last-child") || row;
      const btn = document.createElement("button");
      btn.className = "reset-pass";
      btn.textContent = "ตั้งรหัสใหม่";
      btn.style.marginLeft = "6px";
      btn.style.background = "#1f3b87";
      btn.style.color = "#fff";
      btn.style.border = "0";
      btn.style.borderRadius = "6px";
      btn.style.padding = "6px 8px";
      btn.style.cursor = "pointer";
      btn.onclick = (e) => {
        e.preventDefault();
        const name = getRowName(row);
        if (!name) return alert("ไม่พบชื่อ master");
        window.open(`${API}/password-reset/start?name=${encodeURIComponent(name)}`, "_blank");
      };
      holder.appendChild(btn);
    });
  }

  // Observe re-renders of the chooser
  const mo = new MutationObserver(() => ensureResetButtons());
  mo.observe(document.documentElement, { childList: true, subtree: true });
  ensureResetButtons();

  // Intercept click on "เลือก"
  document.addEventListener("click", async (e) => {
    const btn = e.target;
    if (!btn || !(btn instanceof HTMLElement)) return;
    if (!btn.classList.contains("warning")) return;  // ปุ่ม "เลือก" เดิมใช้คลาส warning
    const row = btn.closest(".item");
    const name = getRowName(row);
    if (!name) return;

    // ถามผู้ใช้ว่าจะ "ใส่รหัส" หรือ "ตั้งรหัสใหม่"
    const usePassword = confirm(`จะเข้า "${name}"?\nOK = ใส่รหัส, Cancel = ไปหน้า 'ตั้งรหัสใหม่'`);
    e.preventDefault();

    if (!usePassword) {
      window.open(`${API}/password-reset/start?name=${encodeURIComponent(name)}`, "_blank");
      return;
    }

    const password = prompt(`ใส่รหัสของ "${name}"\n(ถ้า master นี้ยังไม่มีรหัส ให้เว้นว่างแล้วกด OK)`,"");
    try {
      await postJSON("/setActiveMaster", { name, password: password || "" });
      // โหลด HUD ใหม่
      location.reload();
    } catch (err) {
      alert("เข้าระบบไม่สำเร็จ: " + (err?.message || err));
    }
  }, true);
})();